/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.webserver.internal.core.builtin;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.util.EclipseUtil;
import com.aptana.core.util.SocketUtil;
import com.aptana.webserver.core.IServer;
import com.aptana.webserver.core.SimpleWebServer;
import com.aptana.webserver.core.WebServerCorePlugin;
import com.aptana.webserver.internal.core.builtin.LocalWebServerHttpRequestHandler;
import com.aptana.webserver.internal.core.builtin.Messages;
import com.aptana.webserver.internal.core.preferences.WebServerPreferences;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.nio.DefaultHttpServerIODispatch;
import org.apache.http.impl.nio.reactor.DefaultListeningIOReactor;
import org.apache.http.impl.nio.reactor.IOReactorConfig;
import org.apache.http.nio.NHttpServerEventHandler;
import org.apache.http.nio.protocol.BasicAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.nio.protocol.HttpAsyncRequestHandlerRegistry;
import org.apache.http.nio.protocol.HttpAsyncRequestHandlerResolver;
import org.apache.http.nio.protocol.HttpAsyncService;
import org.apache.http.nio.reactor.IOEventDispatch;
import org.apache.http.nio.reactor.IOReactorException;
import org.apache.http.nio.reactor.IOReactorStatus;
import org.apache.http.nio.reactor.ListeningIOReactor;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;

public class LocalWebServer
extends SimpleWebServer {
    private static final String NAME = "Built-in server";
    private static final int SOCKET_TIMEOUT = 10000;
    private static final long STARTUP_TIMEOUT = 10000L;
    private static final long SHUTDOWN_TIMEOUT = 2000L;
    private static final int SOCKET_BUFFER_SIZE = 16384;
    private static final int WORKER_COUNT = 2;
    private Thread thread;
    private ListeningIOReactor reactor;
    protected int port;
    private String hostName;
    private InetAddress host;

    public LocalWebServer(URI documentRoot) {
        this(WebServerPreferences.getServerAddress(), WebServerPreferences.getPortRange(), documentRoot);
    }

    public LocalWebServer(InetAddress host, int[] portRange, URI documentRoot) {
        Assert.isLegal((documentRoot != null ? 1 : 0) != 0, (String)"DocumentRoot should be set");
        this.setDocumentRoot(documentRoot);
        this.setName(NAME);
        this.host = host;
        this.port = SocketUtil.findFreePort((InetAddress)host, (int)portRange[0], (int)portRange[1]);
        if (this.port <= 0) {
            this.port = SocketUtil.findFreePort((InetAddress)host);
        }
        try {
            this.hostName = host.getHostAddress();
            this.setBaseURL(new URL("http", this.hostName, this.port, "/"));
        }
        catch (MalformedURLException e) {
            IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
        }
    }

    private void testConnection(URL url) throws CoreException {
        CoreException exception = null;
        int trial = 0;
        while (trial < 3) {
            try {
                URLConnection connection = url.openConnection();
                connection.connect();
                connection.getContentType();
                return;
            }
            catch (IOException e) {
                exception = new CoreException((IStatus)new Status(4, "com.aptana.webserver.core", "Testing WebServer connection failed", (Throwable)e));
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e2) {
                    break;
                }
                ++trial;
            }
        }
        if (exception != null) {
            throw exception;
        }
    }

    private void startServer(final InetAddress host, final int port) {
        this.updateState(IServer.State.STARTING);
        this.thread = new Thread(){

            public void run() {
                LocalWebServer.this.runServer(new InetSocketAddress(host, port), (HttpAsyncRequestHandler)new BasicAsyncRequestHandler((HttpRequestHandler)new LocalWebServerHttpRequestHandler(LocalWebServer.this)));
            }
        };
        this.thread.setDaemon(true);
        this.thread.start();
        Thread.yield();
        long startTime = System.currentTimeMillis();
        while (this.thread.isAlive() && System.currentTimeMillis() - startTime < 10000L) {
            if (this.reactor != null && this.reactor.getStatus() == IOReactorStatus.ACTIVE) {
                this.updateState(IServer.State.STARTED);
                break;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                this.updateState(IServer.State.UNKNOWN);
                break;
            }
        }
    }

    private void runServer(InetSocketAddress socketAddress, HttpAsyncRequestHandler httpRequestHandler) {
        BasicHttpParams params = new BasicHttpParams();
        params.setIntParameter("http.socket.timeout", 10000).setBooleanParameter("http.connection.stalecheck", false).setIntParameter("http.socket.buffer-size", 16384).setBooleanParameter("http.tcp.nodelay", true).setParameter("http.origin-server", (Object)("HttpComponents/" + EclipseUtil.getPluginVersion((String)"org.apache.httpcomponents.httpcore")));
        BasicHttpProcessor httpProcessor = new BasicHttpProcessor();
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseDate());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseServer());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseContent());
        httpProcessor.addInterceptor((HttpResponseInterceptor)new ResponseConnControl());
        HttpAsyncRequestHandlerRegistry handlerRegistry = new HttpAsyncRequestHandlerRegistry();
        handlerRegistry.register("*", httpRequestHandler);
        HttpAsyncService serviceHandler = new HttpAsyncService((HttpProcessor)httpProcessor, (ConnectionReuseStrategy)new DefaultConnectionReuseStrategy(), (HttpAsyncRequestHandlerResolver)handlerRegistry, (HttpParams)params);
        IOReactorConfig config = new IOReactorConfig();
        config.setIoThreadCount(2);
        config.setConnectTimeout(10000);
        config.setTcpNoDelay(true);
        config.setSoKeepalive(true);
        DefaultHttpServerIODispatch eventDispatch = new DefaultHttpServerIODispatch((NHttpServerEventHandler)serviceHandler, (HttpParams)params);
        try {
            this.reactor = new DefaultListeningIOReactor(config);
            this.reactor.listen((SocketAddress)socketAddress);
            this.reactor.execute((IOEventDispatch)eventDispatch);
        }
        catch (InterruptedIOException e) {
            return;
        }
        catch (IOReactorException e) {
            IdeLog.logWarning((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)WebServerCorePlugin.getDefault(), (Throwable)e);
        }
    }

    public IStatus stop(boolean force, IProgressMonitor monitor) {
        if (this.thread != null && this.thread.isAlive()) {
            if (this.reactor != null) {
                try {
                    this.reactor.shutdown(2000L);
                }
                catch (IOException ignore) {
                    IdeLog.logWarning((Plugin)WebServerCorePlugin.getDefault(), (String)"An error occurred shutting down the built-in preview server", (Throwable)ignore);
                }
            }
            this.thread.interrupt();
            try {
                this.thread.join(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return Status.OK_STATUS;
    }

    public IStatus start(String mode, IProgressMonitor monitor) {
        if (!"run".equals(mode)) {
            return new Status(4, "com.aptana.webserver.core", Messages.LocalWebServer_ServerModeError);
        }
        try {
            this.startServer(this.host, this.port);
            this.testConnection(this.getBaseURL());
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return Status.OK_STATUS;
    }

    public boolean isPersistent() {
        return false;
    }

    public String getMode() {
        return "run";
    }

    public IServer.State getState() {
        return this.fState;
    }

    public ILaunch getLaunch() {
        return null;
    }

    public IProcess[] getProcesses() {
        return new IProcess[0];
    }

    public InetAddress getHost() {
        return this.host;
    }

    public String getHostname() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }
}

